/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.ChunkPos;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.tasks.BenchmarkTask;
import pregenerator.common.generator.tasks.CircleExpansionTask;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.SquareExpansionTask;
import pregenerator.common.generator.tasks.SquareTask;

public interface ITask
extends IBaseTask<ChunkProcess> {
    public static final Int2ObjectMap<Function<CompoundTag, ITask>> TASK_REGISTRY = new Int2ObjectOpenHashMap();

    public static void init() {
        TASK_REGISTRY.put(1, SquareTask::new);
        TASK_REGISTRY.put(2, CircleTask::new);
        TASK_REGISTRY.put(3, SquareExpansionTask::new);
        TASK_REGISTRY.put(4, CircleExpansionTask::new);
        TASK_REGISTRY.put(5, BenchmarkTask::new);
    }

    public static ITask loadTask(CompoundTag nbt) {
        Function creator = (Function)TASK_REGISTRY.get(nbt.m_128451_("id"));
        if (creator == null) {
            return null;
        }
        ITask task = (ITask)creator.apply(nbt);
        return task == null || !task.isValid() ? null : task;
    }

    public static CompoundTag saveTask(ITask task) {
        if (task == null) {
            return null;
        }
        CompoundTag nbt = task.write();
        nbt.m_128344_("id", task.getId());
        return nbt;
    }

    public static MutableComponent convert(String s, MutableComponent parent, ChatFormatting ... formats) {
        TextComponent comp = new TextComponent(s);
        comp.m_130944_(formats);
        parent.m_7220_((Component)comp);
        return comp;
    }

    public UUID getTaskId();

    public UUID getOwner();

    public void setOwner(UUID var1);

    public int getGenType();

    public ChunkPos getCenter();

    public int getMaxRadius();

    public void onCompletion(Duration var1, Duration var2, long var3);
}

